# Lesson 12: What's Next (Course Complete)

Let's take stock. You now have:

- **A file system:** inbox/ → processed/ → outputs/ with reference/
- **Core skills:** File Processor, Research Synthesizer, Document Creator
- **Custom skills:** 3 skills designed for your specific work
- **Mental models:** Worker not chatbot, Done framework, batch delegation

This is a working system, not just knowledge.

WAIT: What's the biggest mental shift for you since Lesson 1?

USER: [Reflects on their shift – worker vs chatbot, delegation, batching, etc.]

That shift is worth more than any individual skill. It changes how you work with AI entirely.

---

**Connectors** – Cowork has built-in integrations with Gmail, Google Calendar, Notion, Asana, Slack, and more.

Honest truth: they're unreliable right now. Most don't work consistently.

I left them out so you wouldn't get frustrated.

When they stabilize, they'll be powerful. Check back for updates.

WAIT: Makes sense?

USER: Yes

---

**Use Cowork when:**

- The work lives in your files
- You need actual documents (Excel, PowerPoint, Word)
- You're processing lots of files or sources
- You want to queue tasks and walk away
- Regular chat would hit context limits

**Use regular Claude when:**

- You're asking questions or having a discussion
- You don't need file access
- The task is quick and simple
- You want to save your usage allocation

WAIT: Your friend asks "should I use Cowork or regular Claude to plan a vacation?" – what do you tell them?

USER: [Explains – probably regular Claude unless they have a folder of travel docs to analyze]

Good advice. Cowork is for file-based work, not general chat.

---

Here are 25+ use cases that actually work well:

**Financial & Administrative:**
- Turn 50 receipt photos into categorized expense spreadsheet with totals
- Extract key dates, amounts, obligations from a folder of contracts
- Create invoice summaries from scattered PDF invoices
- Build a budget tracker from bank statement exports
- Generate monthly expense reports from transaction data

**Research & Analysis:**
- Synthesize 30 customer interview transcripts into themes report
- Compare four vendors on pricing, features, and reviews
- Analyze competitor marketing materials for positioning insights
- Extract and organize highlights from annotated PDFs
- Create a literature review from research papers

**Content & Documents:**
- Turn meeting notes into formatted slide deck
- Create project brief from scattered planning documents
- Generate FAQ document from customer support chat logs
- Build style guide from examples of approved content
- Turn long report into executive summary

**File Management:**
- Organize chaotic Downloads folder by project and date
- Find and consolidate duplicate files across subfolders
- Rename files in bulk using consistent naming convention
- Sort photos by date and create organized album folders
- Archive old files while creating index of what was moved

**Data Processing:**
- Extract data from screenshots of forms or tables
- Combine multiple CSV files into single organized spreadsheet
- Clean and standardize messy data exports
- Convert between file formats in bulk
- Extract specific fields from large set of documents

WAIT: Any of those spark ideas?

USER: [Response]

---

People have used Claude for:

- Vacation research and itinerary planning
- Cancelling unused subscriptions (found them in statements, researched how to cancel each)
- Recovering and organizing wedding photos from corrupted drives
- Monitoring plant growth from photos over time
- Building entire slide decks from scratch
- Cleaning up email backlogs

The tool is general-purpose. If it can be done with files and web access, try it.

WAIT: Any creative ideas for your own work?

USER: [Response]

---

Before I let you go, safety checklist:

**Before sessions:** Back up important files. Decide what I'm NOT allowed to delete.

**Every session:** Be explicit about constraints. Avoid putting truly sensitive files in the work folder.

**If something seems off:** Stop the task. Check what files were modified.

I'm powerful, but I can make mistakes. Review my work. Keep backups.

WAIT: What's ONE safety habit you'll commit to?

USER: [Commits to a specific habit]

Good. Stick with that.

---

Here's your homework:

Today, pick ONE real task from your actual work.

Something you were going to do manually.

Delegate it to Cowork instead.

Use the Done framework. Be specific.

See what happens.

That's how you actually learn – by doing real work.

WAIT: What's the first real task you're going to try?

USER: [Response]

---

Remember:

- I'm a worker, not a chatbot. Put me to work.
- Specific inputs = specific outputs.
- Skills make me consistent. Build them over time.
- Batch tasks. Walk away. Come back to finished work.

The tool is early. It will get better. Start learning now.

Thanks for learning with me.

**Course Complete.**

WAIT: Go delegate something real. I'll be here when you need me.

USER: [Exits or continues exploring]
