# Lesson 10: The AI Employee Pattern

Here's how most people use Cowork:

Give task → Wait → Get result → Give next task → Wait → Get result

That's still chatbot thinking.

Here's the AI Employee pattern:

Brain dump tasks → Hand them off → Go do something else → Come back to finished work

WAIT: Which pattern matches how YOU currently work with AI?

USER: [Reflects on their current pattern]

---

Instead of three separate sessions:

- "Organize my receipts" → wait → done
- "Create expense report" → wait → done
- "Summarize for my accountant" → wait → done

Do this – one session, one prompt:

"I have receipt screenshots in /receipts. First, organize them by month into subfolders. Then create an expense spreadsheet with all the data. Finally, create a one-page summary for my accountant showing totals by category. Put all outputs in /outputs."

One session. Three tasks. Less time. Less usage.

WAIT: Take those three separate tasks I showed. How would YOU phrase them as one batched delegation?

USER: [Attempts to write a batched prompt]

[Feedback on their attempt – reinforce good parts, suggest improvements if needed]

That's the idea. Chain tasks together, be specific about each output, and let me work through them.

---

You don't have to wait for one task before giving the next.

The sidebar shows progress – what steps are unfolding, what tools I'm using, what outputs I'm creating.

Monitor if you want. Or check in later.

WAIT: Ready to try batching?

USER: Yes

---

Give me 3 related tasks to do together.

They should flow into each other or use the same files.

Remember the Done framework – be specific about what "done" looks like for each.

WAIT: What 3 tasks should I batch together?

USER: [Three related tasks]

---

ACTION: Work through all three tasks

ACTION: Report progress as I go

ACTION: Create all outputs

Done. All three tasks complete.

WAIT: Check the outputs. How'd I do?

USER: [Response]

---

One thing to know: Cowork uses more of your allocation than regular chat.

Complex, multi-step tasks are compute-intensive.

Batching related work is more efficient than separate sessions.

Use regular Claude chat for quick questions that don't need file access.

WAIT: Good to know?

USER: Yes

---

Here's how some people use Cowork daily:

- **Morning:** Brain dump tasks for the day
- **Hand them to Cowork:** "Here's what I need done..."
- **Go do deep work,** meetings, whatever
- **Check in:** Review outputs, give feedback
- **Iterate:** "Change this, add that, redo this part"

It's like having an assistant who works in your file system.

WAIT: Picture tomorrow morning. What would YOUR brain dump look like? What 2-3 tasks would you hand off?

USER: [Describes their morning tasks]

That's a perfect Cowork morning. You could literally do that tomorrow.

---

**What you learned:** Batch delegation, queue tasks, walk away.

**Key insight:** Think in workflows, not individual tasks.

**Next up:** Building your personal skill library – the final piece.

**To continue:** Start a fresh Cowork session and say: *"Read START-HERE.md and start lesson 11"*
