# Lesson 9: Browser Automation

Everything so far has been local – files on your computer.

But I can also control Chrome through the Claude-in-Chrome extension.

Navigate, click, extract data, fill forms.

WAIT: Have you installed Claude-in-Chrome?

USER: Yes / No / Not sure

[If no/not sure]: You'll need it for this lesson. Want to skip to the next lesson and come back later?

---

Good use cases:

- Extract data from dashboards you're logged into
- Research across multiple websites
- Pull information from behind logins
- Competitive pricing research

WAIT: Think about your work – what dashboard or logged-in page would be most valuable to pull data from? Analytics? CRM? Project management tool?

USER: [Names a specific dashboard or tool]

That's exactly the kind of thing browser automation is built for. Let's start simpler, but keep that in mind.

---

I need to be upfront: browser automation is hit or miss.

Pages load weird. Elements don't respond. Sites block automation.

It works great sometimes. Gets stuck other times.

If I get stuck, just tell me to try again or skip that part.

WAIT: Good to set expectations?

USER: Yes

---

Let's try something simple: extract data from a webpage.

WAIT: Give me a URL with data you want extracted. (A public page – product listings, search results, pricing page, anything.)

USER: [URL]

---

ACTION: Navigate to the URL

ACTION: Extract relevant data

ACTION: Save to a local file

Done. Check the extracted data.

WAIT: Accurate?

USER: [Response]

---

Important safety note:

Browser access introduces risks. Malicious sites could try to manipulate my behavior through hidden instructions.

Stick to trusted sites. Don't send me to random URLs from unknown sources.

I'll always ask before submitting forms or taking actions that can't be undone.

WAIT: What's a site you'd trust vs. one you wouldn't send me to?

USER: [Response – trusted: work tools, known companies. Untrusted: random links, sketchy sites]

Good instincts. Stick with those.

---

Quick framework:

- **Web search** = Public information, general research, multiple sources
- **Browser** = Logged-in dashboards, specific pages you need to navigate, form interactions

Most research is better with web search. Browser is for specific data you can't get otherwise.

WAIT: Quick test – if you wanted data from your bank dashboard, would you use browser or web search?

USER: Browser

Right – because you need to be logged in. Web search can't see behind logins.

---

**What you learned:** Browser automation basics and limitations.

**Key insight:** Browser access is powerful but unreliable. Set expectations accordingly.

**Next up:** The AI Employee pattern – batching tasks and walking away.

**To continue:** Start a fresh Cowork session and say: *"Read START-HERE.md and start lesson 10"*
