# Lesson 8: Document Creation (Excel, PowerPoint, Word)

This is where Cowork differs from regular Claude.

When you ask me to create a spreadsheet, you get a real .xlsx file. With working formulas. Multiple sheets. Charts.

Not a table I ask you to copy-paste. An actual file.

Same for PowerPoint, Word docs, PDFs.

WAIT: Ready to see this?

USER: Yes

---

Here's a classic use case that blew people's minds in demos:

Someone dumped credit card statements into Cowork. Got back an Excel spreadsheet with all subscriptions, which ones to cancel, and HOW to cancel each one.

Let's do something similar.

ACTION: Show the receipt images/PDFs in scenarios/receipts/

These are receipts. Different formats, some are photos, some are PDFs.

WAIT: What columns would YOU want in an expense tracker?

USER: [Lists columns – date, vendor, amount, category, etc.]

Good. Let me build that.

---

ACTION: Read all receipt files (including images)

ACTION: Create expense-tracker.xlsx with:
- Data sheet with the columns they specified
- Formulas for totals by category
- Conditional formatting for large expenses
- Summary sheet with charts
- Flagged items sheet for unclear receipts

Done. Download expense-tracker.xlsx and open it.

WAIT: Does it have working formulas? Check the totals.

USER: [Response]

---

Things I handle well in Excel:

- SUM, AVERAGE, VLOOKUP, IF formulas
- Conditional formatting
- Multiple sheets
- Charts and graphs
- Data validation

This is real Excel. Edit it, share it, build on it.

WAIT: Ready for presentations?

USER: Yes

---

ACTION: Show the scattered notes in scenarios/strategy-notes/

These are messy strategy notes. Good ideas, no structure.

Your job: turn this into a presentation for executives.

WAIT: Who's the audience and what's the goal?

USER: [Audience and goal]

---

ACTION: Read all strategy notes

ACTION: Create strategy-presentation.pptx with:
- Title slide
- Executive summary
- Key strategic pillars
- Supporting data/evidence
- Risks and mitigations
- Recommendations
- Next steps

Done. Download and open strategy-presentation.pptx.

WAIT: Real slides with layouts?

USER: [Response]

---

Things I handle well in PowerPoint:

- Actual slide layouts (not just bullet points)
- Multiple slides with logical flow
- Basic formatting and structure
- Speaker notes

It's a real .pptx – edit it in PowerPoint, add images, refine design.

WAIT: Ready to systematize this?

USER: Yes

---

Let's create a skill for document creation.

WAIT: Any specific preferences? Brand voice? Formatting standards? Default structures?

USER: [Preferences or "keep it standard"]

---

ACTION: Create skills/document-creator.md with:
- Voice/tone preferences
- Default structures for different document types
- Formatting standards
- When to use Excel vs. Word vs. PowerPoint

Your Document Creator skill is ready.

WAIT: Three skills now. You've got a real system.

USER: Yes

---

**What you learned:** Real file creation – Excel with formulas, PowerPoint with slides.

**What you built:** Document Creator skill with your preferences.

**Key insight:** These are actual files you can edit and share. Not text to copy-paste.

**Next up:** Browser automation – reaching beyond your local files.

**To continue:** Start a fresh Cowork session and say: *"Read START-HERE.md and start lesson 9"*
